//
//  GMObjCDef.h
//  Created by lifei on 2019/7/17.
//  Copyright © 2019 lifei. All rights reserved.

/**
 1. GM/T 0003-2012 标准推荐参数  sm2p256v1（NID_sm2）；
 2. 若需使用其他曲线，可在 OpenSSL 源码 crypto/ec/ec_curve.c 中查找。
 
 ECC推荐参数：sm2p256v1（对应 OpenSSL 中 NID_sm2）
 p   = FFFFFFFE FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF 00000000 FFFFFFFF FFFFFFFF
 a   = FFFFFFFE FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF 00000000 FFFFFFFF FFFFFFFC
 b   = 28E9FA9E 9D9F5E34 4D5A9E4B CF6509A7 F39789F5 15AB8F92 DDBCBD41 4D940E93
 n   = FFFFFFFE FFFFFFFF FFFFFFFF FFFFFFFF 7203DF6B 21C6052B 53BBF409 39D54123
 Gx =  32C4AE2C 1F198119 5F990446 6A39C994 8FE30BBF F2660BE1 715A4589 334C74C7
 Gy =  BC3736A2 F4F6779C 59BDCEE3 6B692153 D0A9877C C62A4740 02DF32E5 2139F0A0

 ECC推荐参数：secp256k1（对应 OpenSSL 中 NID_secp256k1）
 p   = FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFE FFFFFC2F
 a   = 00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
 b   = 00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000007
 n   = FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFE BAAEDCE6 AF48A03B BFD25E8C D0364141
 Gx =  79BE667E F9DCBBAC 55A06295 CE870B07 029BFCDB 2DCE28D9 59F2815B 16F81798
 Gy =  483ADA77 26A3C465 5DA4FBFC 0E1108A8 FD17B448 A6855419 9C47D08F FB10D4B8

 ECC推荐参数：secp256r1（对应 OpenSSL 中 NID_X9_62_prime256v1）
 p   = FFFFFFFF 00000001 00000000 00000000 00000000 FFFFFFFF FFFFFFFF FFFFFFFF
 a   = FFFFFFFF 00000001 00000000 00000000 00000000 FFFFFFFF FFFFFFFF FFFFFFFC
 b   = 5AC635D8 AA3A93E7 B3EBBD55 769886BC 651D06B0 CC53B0F6 3BCE3C3E 27D2604B
 n   = FFFFFFFF 00000000 FFFFFFFF FFFFFFFF BCE6FAAD A7179E84 F3B9CAC2 FC632551
 Gx  = 6B17D1F2 E12C4247 F8BCE6E5 63A440F2 77037D81 2DEB33A0 F4A13945 D898C296
 Gy  = 4FE342E2 FE1A7F9B 8EE7EB4A 7C0F9E16 2BCE3357 6B315ECE CBB64068 37BF51F5
 */

#ifndef GMObjCDef_h
#define GMObjCDef_h

#ifdef DEBUG
#define GMLog(...) NSLog(__VA_ARGS__)
#else
#define GMLog(...)
#endif

// 常用标准椭圆曲线，默认 NID_sm2，一般不需更改
typedef NS_ENUM(int, GMCurveType) {
    GMCurveType_sm2p256v1 = 1172,   // NID_sm2(默认)
    GMCurveType_secp256k1 = 714,    // NID_secp256k1
    GMCurveType_secp256r1 = 415     // NID_X9_62_prime256v1
};

// HMAC 算法主要类型
typedef NS_ENUM(int, GMHashType) {
    GMHashType_SM3 = 0,     // EVP_sm3(void)(默认)
    GMHashType_MD5,         // EVP_md5(void)
    GMHashType_SHA1,        // EVP_sha1(void)
    GMHashType_SHA224,      // EVP_sha224(void)
    GMHashType_SHA256,      // EVP_sha256(void)
    GMHashType_SHA384,      // EVP_sha384(void)
    GMHashType_SHA512       // EVP_sha512(void)
};

#endif /* GMObjCDef_h */

