//
//  Zhuge.h
//
//  Copyright (c) 2014 37degree. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "ZhugeHeaders.h"

NS_ASSUME_NONNULL_BEGIN


@interface Zhuge : NSObject

#pragma mark - 获取实例

/**
 * 获取诸葛统计的实例。
 */
+ (nonnull Zhuge*)sharedInstance;

+(nonnull Zhuge *)newInstance;
/**
 *  全埋点和可视化埋点均默认处理了UILabel与UIImageView的手势情况.如有新自定义视图需要识别.可添加到该集合中. 例如:@[@"ZGTestGestureView"];则ZGTestGestureView以及其继承的子类添加手势以后均可被识别到.
 */
+(void) setCustomGestureViews:(NSArray*) views;
+(NSArray *)getCustomGestureViews;
+(void)openLog;
+(BOOL)isLogEnable;
+(void)setPrivacyAgree:(BOOL) agree;
+(void)setPrivacyControl:(BOOL)enable;
/**
 * 获得诸葛配置实例。
 */
- (nonnull ZhugeConfig *)config;

/**
 * 设置utm信息。
 */
-(void)setUtm:(nonnull NSDictionary *)utmInfo;

/**
 * 获得诸葛设备ID。
 */
+ (nonnull NSString *)getDid;
- (nonnull NSString *)getSid;

#pragma mark - 开启统计
/**
 * 自动统计页面停留时长
 */
- (void)enabelDurationOnPage;

/**
 * 开启全埋点采集
 */
- (void)enableAutoTrack;
/**
 * 开启曝光采集 Exposure
 */
- (void)enableExpTrack;

/**
 开启诸葛统计。
 @param appKey 应用Key，网站上注册应用时自动获得
 @param launchOptions 启动项
 */
- (void)startWithConfig:(nonnull ZhugeConfig*)config;

- (void)startWithConfig:(nonnull ZhugeConfig*)config launchOptions:(nullable NSDictionary*)launchOptions;

- (void)startWithConfig:(nonnull ZhugeConfig *)config andDid:(nonnull NSString*)did launchOptions:(nullable NSDictionary *)launchOptions;


#pragma mark - 追踪用户行为
/**
 标识用户。
 @param userId     用户ID
 @param properties 用户属性
 */
- (void)identify:(nonnull NSString*)userId properties:(nullable NSDictionary *)properties;

/**
 userID不变，仅更新用户属性
 @param properties 属性
 */
- (void)updateIdentify:(nonnull NSDictionary *)properties;


/**
 * 设置事件环境信息，通过这个地方存入的信息将会给之后传入的每一个事件添加环境信息
 */
-(void)setSuperProperty:(nonnull NSDictionary *)info;

-(void)addSuperProperty:(nonnull NSDictionary*)info;

-(void)addSuperPropertyWithKey:(nonnull NSString*)key value:(nullable NSString *) value;
-(void)deleteSuperPropertyWithKey:(nonnull NSString*)key;
-(void)clearSuperProperty;
-(void)setPlatform:(nonnull NSDictionary *)info;
-(NSDictionary *)getSuperProperties;
/**
 * 追踪自定义事件。
 * @param event      事件名称
 */
- (void)track:(nonnull NSString *)event;

/**
 * 追踪自定义事件。
 * @param event      事件名称
 * @param properties 事件属性
 */
- (void)track:(nonnull NSString *)event properties:(nullable NSDictionary *)properties;
/**
 开始追踪一个耗时事件，这个借口并不会真正的统计这个事件。当你调用endTrack时，会统计两个接口之间的耗时，
 并作为一个属性添加到事件之中
 @param eventName 事件名称
 */
- (void)startTrack:(nonnull NSString *)eventName;
- (void)endTrack:(nonnull NSString *)eventName properties:(nullable NSDictionary *)properties;


/** 追踪收入事件
 *  @param properties 事件属性
 */
- (void)trackRevenue:(nullable NSDictionary *)properties;

/**
 * @param properties 全埋点属性
 */
- (void)autoTrack:(nonnull NSDictionary *)properties;

/// 可视化埋点上报
/// - Parameter properties: 上报数据
- (void)zgVisualizationTrack:(nonnull NSDictionary *)properties;

/**
 * @param properties 页面时长需携带的属性
 */
- (void)trackDurationOnPage:(NSDictionary *)properties;

/**
 * 向 WKWebView 注入 Message Handler
 * @param webView 需要注入的 wkwebView
*/
+ (void)addScriptMessageHandlerWithWebView:(WKWebView *)webView;


// 处理接收到的消息
- (void)handleRemoteNotification:(nonnull NSDictionary *)userInfo;

// 设置第三方推送用户ID
- (void)setThirdPartyPushUserId:(nonnull NSString *)userId forChannel:(ZGPushChannel) channel;

// 处理AppSee数据上传



+ (UIApplication *)sharedUIApplication;

/// 与PC端链接.开始可视化埋点工作.
/// @param url 扫码获取的地址
+(void)zg_startVisualizationDebuggingTrack:(NSURL *)url;
//开启广告ID收集
+(void)enableIDFACollect;
//是否开启了广告ID收集
+(BOOL)isIDFAEnable;
+(NSArray *)allInstance;
+(NSArray *)autoTrackInstance;
+(NSArray *)durationOnPageInstance;
+(NSArray *)exposeInstance;
+(NSArray *)visualInstance;
+(Zhuge *)getInstanceForKey:(NSString *)appkey;
@end


NS_ASSUME_NONNULL_END
